<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\select2\Select2;

/* @var $this yii\web\View */
/* @var $model common\models\Networks */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="networks-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'ip')->textInput()->label('IP or Network as xxx.xxx.xxx.xxx [- xxx.xxx.xxx.xxx]') ?>

    <?= $form->field($model, 'ip1')->hiddenInput()->label(false) ?>

    <?= $form->field($model, 'ip2')->hiddenInput()->label(false) ?>
  
    <?= $form->field($model, 'destination')->widget(Select2::classname(), [
        'data' => [
            '0' => 'Network',
            '1' => 'Honeypot',
            '2' => 'Test',
            ],
        ]) ?>

    
    <?= $form->field($model, 'comment')->textarea(['rows' => 6]) ?>

    
	<?php if (!Yii::$app->request->isAjax){ ?>
	  	<div class="form-group">
	        <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
	    </div>
	<?php } ?>

    <?php ActiveForm::end(); ?>
    
</div>
